<?php echo $__env->make('components.teaching-reports-report.teaching-reports-report-head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body>
    <?php $__currentLoopData = $studentGrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentGrade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
    $classRoom = $studentGrade['class_room'] ?? null;
    ?>

    <div class="report-card">
        <!-- header -->
        <table class="header-table">
            <tr>
                <td style="width: 25%; font-size: 10pt;">
                    کد مدرسه: <?php echo e($reportInfo['school_code']); ?><br>
                    استان: <?php echo e($reportInfo['school_province']); ?><br>
                    ناحیه: <?php echo e($reportInfo['school_district']); ?>

                </td>
                <td class="header-center">
                    <img class="logo-box" src="<?php echo e(public_path('storage/schools/images/logo.png')); ?>" />

                    <p style="margin: 0;"><?php echo e($reportInfo['school_title']); ?></p>
                </td>
                <td style="width: 25%; font-size: 10pt; text-align: left;">
                    سال: <?php echo e($getYear()); ?><br>
                    نوبت: <?php echo e($getTerm()); ?><br>
                    نوع: <?php echo e($reportInfo['school_type']); ?>

                </td>
            </tr>
        </table>

        <!-- information -->
        <table class="student-info-table">
            <tr>
                <td style="vertical-align: middle;">
                    <strong>کد کلاس:</strong> <?php echo e($classRoom['code'] ?? '-'); ?><br><br>
                    <strong>پایه:</strong> <?php echo e($classRoom['academic_level']['title'] ?? '-'); ?><br><br>
                    <strong>رشته:</strong> <?php echo e($classRoom['major']['title'] ?? '-'); ?><br><br>
                </td>
                <td style="vertical-align: middle;">
                    <strong>نام و نام خانوادگی:</strong> <?php echo e($fullName($studentGrade)); ?><br><br>
                    <strong>نام پدر:</strong> <?php echo e($fatherName($studentGrade)); ?><br><br>
                    <strong>کد ملی:</strong> <?php echo e($studentGrade['national_code'] ?? '-'); ?><br><br>
                </td>
                <td style="text-align: left;">
                    <div class="photo-container">
                        <!-- student image -->
                        <?php if(isset($studentGrade['image'])): ?>
                        <img
                            class="student-photo"
                            src="<?php echo e(storage_path('app/private/students/images/'. $studentGrade['image']['name'])); ?>" />
                        <?php else: ?>
                        <img
                            class="student-photo"
                            src="<?php echo e(resource_path('assets/images/avatar.png')); ?>" />
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        </table>

        <!-- table grades-->
        <table class="grades-table">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 40px;">ردیف</th>
                    <th rowspan="2">کد درس</th>
                    <th rowspan="2">نام درس</th>
                    <th colspan="2">نمرات نوبت اول</th>
                    <th colspan="<?php echo e($term != 2 ? 2 : 3); ?>">نمرات دروس پودمانی</th>
                    <th rowspan="2">نتیجه</th>
                    <th rowspan="2">اساتید</th>
                </tr>
                <tr>
                    <th>مستمر</th>
                    <th>پایانی</th>

                    <?php if($term != 2): ?>
                    <th>پودمانی 1</th>
                    <th>پودمانی 2</th>
                    <?php else: ?>
                    <th>پودمانی 3</th>
                    <th>پودمانی 4</th>
                    <th>پودمانی 5</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $studentGrade['teaching_reports']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $teaching_report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class=<?php echo e($passingLesson($teaching_report)?'':'failed-row'); ?>>
                    <td><?php echo e($idx + 1); ?></td>
                    <td><?php echo e($teaching_report['lesson']['id'] ?? '-'); ?></td>
                    <td><?php echo e($teaching_report['lesson']['title'] ?? '-'); ?></td>
                    <td><?php echo e($teaching_report['genesis_grade'] ?? '-'); ?></td>
                    <td><?php echo e($teaching_report['final_grade'] ?? '-'); ?></td>

                    <?php if($term != 2): ?>
                    <td><?php echo e($teaching_report['podmany_one_grade'] ?? '-'); ?></td>
                    <td><?php echo e($teaching_report['podmany_two_grade'] ?? '-'); ?></td>
                    <?php else: ?>
                    <td><?php echo e($teaching_report['podmany_three_grade'] ?? '-'); ?></td>
                    <td><?php echo e($teaching_report['podmany_four_grade'] ?? '-'); ?></td>
                    <td><?php echo e($teaching_report['podmany_five_grade'] ?? '-'); ?></td>
                    <?php endif; ?>

                    <td><?php echo e($passingLesson($teaching_report) ? 'قبول' : 'مردود'); ?></td>
                    <td><?php echo e($fullNameTeachers($teaching_report['lesson'])); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="gpa-box">
            معدل دوره: <?php echo e($finalGrade($studentGrade['teaching_reports'])); ?>

        </div>

        <!-- signature -->
        <table class="signature-table">
            <tr>
                <td>مهر و امضای معاون اجرایی</td>
                <td>مهر و امضای مدیریت آموزشگاه</td>
            </tr>
            <tr>
                <td>...........................</td>
                <td>...........................</td>
            </tr>
        </table>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body><?php /**PATH /home/lgroupir/public_html/pol-v2.tahlilfan.ir/backend/core/resources/views/components/teaching-reports-report/teaching-reports-report.blade.php ENDPATH**/ ?>